import React from "react";
import { Form } from "semantic-ui-react";
import BaseField, { BaseFieldProps } from "../BaseField";

class StringField extends BaseField {
  constructor(props: BaseFieldProps) {
    super(props);
    this.state = { value: "" };
  }

  override compareValues(a: any, b: any): boolean {
    return a === b || (!a && !b);
  }

  override render() {
    const { field, value, error, hidden, disabled, readOnly } = this.state;
    if (!field || hidden) {
      return null;
    }
    return (
      <Form.Field
        control={Form.Input}
        label={field.label}
        placeholder={field.label}
        required={field.required}
        value={value}
        error={error ? { content: error, pointing: "below" } : undefined}
        disabled={disabled}
        readOnly={readOnly}
        onInput={(e: React.FormEvent<HTMLInputElement>) => this.onChange(e.currentTarget.value)}
        className={`StringField__${field.name}`}
      />
    );
  }
}

export default StringField;
