import React from "react";
import { Form, Label } from "semantic-ui-react";
import classNames from "classnames";
import BaseField, { BaseFieldProps, BaseFieldState } from "../BaseField";
import PassField from "components/PasswordField";

type PasswordFieldState = BaseFieldState & {
  showPassword: boolean;
};

class PasswordField extends BaseField<BaseFieldProps, PasswordFieldState> {
  constructor(props: BaseFieldProps) {
    super(props);
    this.state = { value: "", showPassword: false };
  }

  override compareValues(a: any, b: any): boolean {
    return a === b || (!a && !b);
  }

  override render() {
    const { field, value, error, hidden, disabled, readOnly } = this.state;
    if (!field || hidden) {
      return null;
    }
    return (
      <Form.Field
        required={field.required}
        disabled={disabled}
        readOnly={readOnly}
        error={!!error}
        className={`PasswordField__${field.name}`}
      >
        <label>{field.label}</label>
        {!!error && <Label pointing="below" prompt>{error}</Label>}
        <div className={classNames("field", { "required": field.required })}>
          <PassField
            value={value}
            placeholder={field.label}
            onChange={(value) => this.onChange(value)}
          />
        </div>
      </Form.Field>
    );
  }
}

export default PasswordField;
