import React from "react";
import { Form, Button } from "semantic-ui-react";
import BaseField, { BaseFieldProps } from "../BaseField";

class ButtonField extends BaseField {
  constructor(props: BaseFieldProps) {
    super(props);
    this.state = { value: null };
  }

  override getDefaultValue(): any {
    return null;
  }

  override compareValues(a: any, b: any): boolean {
    return true;
  }

  override render() {
    const { field, hidden, disabled } = this.state;
    if (!field || hidden) {
      return null;
    }
    return (
      <Form.Field>
        <Button
          content={field.label}
          disabled={disabled}
          onClick={() => field.action && field.action()}
          className={`ButtonField__${field.name}`}
        />
      </Form.Field>
    );
  }
}

export default ButtonField;
