import React from "react";
import {Route, RouteProps} from "react-router-dom";
import {list} from "./routes";
import LazyComponent from "components/LazyComponent";

export function Router(routes: []) {
  return (props: any) => {
    return (
      <div className="router">
        {routes.map((config: any) => (
          <Route {...config} />
        ))}
      </div>
    );
  };
}

export async function createServerRoutes(): Promise<RouteProps[]> {
  const routes: RouteProps[] = [];
  for (const route of list) {
    const response = await route.render();
    if (!response) continue;
    const DefaultComponent = response.default;
    const newConfig = { ...route, component: DefaultComponent };
    // @ts-ignore
    delete newConfig.render;
    routes.push(newConfig);
  }
  return routes;
}

export function createBrowserRoutes(): RouteProps[] {
  const routes: RouteProps[] = [];
  for (const route of list) {
    const newConfig = {
      ...route,
      render: () => <LazyComponent render={() => route.render()} />,
    };
    routes.push(newConfig);
  }

  return routes;
}
