import React from "react";
import { Button, Icon, Popup, Segment } from "semantic-ui-react";

import { SensorEvent } from "@generated/graphql";
import { __ } from "@solid/libs";

import ButtonsWrapper from "components/Admin/Sensors/ButtonsWrapper";
import EntityTable, { EntityTableProps } from "components/EntityTable";

import "./style.css";

type AssignedEventsProp = {
  events?: SensorEvent[];
  removeEvent: (type: string) => void;
  getEventsToAssign: () => void;
};

const AssignedEvents = React.memo(({ events, removeEvent, getEventsToAssign }: AssignedEventsProp) => {
  const assignedEventsTableProps: EntityTableProps = {
    columns: ["", "Description"],
    widths: [undefined, 16],
    emptyLine: __("No assigned events"),
    rows: events?.reduce((acc, event, index) => {
      acc.push([
        <Popup
          trigger={<Icon name="remove" onClick={() => removeEvent(event.type)}/>}
          content={__("Remove event from sensor")}
        />,
        <span>&nbsp;{event.description}</span>
      ]);
      return acc;
    }, [] as React.ReactNode[][])
  };

  return (
    <Segment className="AssignedEvents">
      <ButtonsWrapper>
        <Button onClick={() => getEventsToAssign()}>{__("Assign Events")}</Button>
      </ButtonsWrapper>
      <EntityTable {...assignedEventsTableProps} />
    </Segment>
  );
});

export default AssignedEvents;
