import React from "react";
import { Icon, Popup } from "semantic-ui-react";

import { SensorShort } from "@core/actions";
import { __ } from "@solid/libs";

type TableActionsProps = {
  onSelect: (sensor: SensorShort) => void;
  onDelete: (sensor: SensorShort) => void;
  sensor: SensorShort;
};

const TableActions = React.memo(({ onSelect, onDelete, sensor }: TableActionsProps) => {
  return (
    <>
      <Popup
        trigger={
          <Icon name="edit" className="SensorActions-IconButton" onClick={(e: React.MouseEvent) => {
            e.stopPropagation();
            onSelect(sensor);
          }}/>
        }
        content={__("Configure")}
      />
      <Popup
        trigger={
          <Icon name="trash alternate" className="SensorActions-IconButton" onClick={(e: React.MouseEvent) => {
            e.stopPropagation();
            onDelete(sensor);
          }}/>
        }
        content={__("Delete")}
      />
    </>
  );
});

export default TableActions;
