import React from "react";
import { Button, Header, Icon, Modal } from "semantic-ui-react";

import { SensorShort } from "@core/actions";
import { __ } from "@solid/libs";

type DeleteModalProps = {
  device: SensorShort;
  onDelete: (device: SensorShort) => void;
  onCancel: () => void;
};

const DeleteModal = ({ device, onDelete, onCancel }: DeleteModalProps) => {
  return (
    <Modal open onClose={() => onCancel()}>
      <Header>{__("Delete Device")}</Header>
      <Modal.Content>{__("Are you sure you want to delete device '{{name}}'?", {name: device.name})}</Modal.Content>
      <Modal.Actions>
        <Button negative onClick={() => onDelete(device)}>
          <Icon name="trash"/>{__("Delete")}
        </Button>
        <Button onClick={() => onCancel()}>
          <Icon name="cancel"/>{__("Cancel")}
        </Button>
      </Modal.Actions>
    </Modal>
  );
};

export default DeleteModal;
