import React from "react";
import { Segment } from "semantic-ui-react";
import { AutoSizer, Column, Table } from "react-virtualized";
import { GatewayShort, healthStatusText } from "@core/actions";
import { __ } from "@solid/libs";
import { TableActions } from "./TableActions";
import {UUID} from "@solid/types";

type GatewaysTableProps = {
  list: GatewayShort[];
  loading?: boolean;
  onSelect: (device: GatewayShort) => void;
  onDelete: (device: GatewayShort) => void;
  createdId?: UUID
};

const GatewayTable = ({ list, loading, onSelect, onDelete, createdId }: GatewaysTableProps) => {
  return (
    <Segment loading={loading} className="GatewayTable-Wrapper">
      <AutoSizer style={{ width: "100%", height: "100%" }}>
        {({ width, height }) => (
          <Table
            className="GatewayTable"
            width={width}
            height={height}
            rowHeight={34}
            headerHeight={58}
            rowCount={list.length}
            rowGetter={({ index }) => list[index]}
            rowClassName={({ index }) => list[index] && createdId === list[index].id ? "added" : ""}          >
            <Column
              dataKey="actions"
              label=""
              width={60}
              flexShrink={0}
              cellRenderer={({ rowData }: { rowData: GatewayShort }) => <TableActions onSelect={onSelect} onDelete={onDelete} gateway={rowData} />}
            />
            <Column dataKey="name" label={__("Name")} width={100} flexGrow={1} />
            <Column
              dataKey="enabled"
              label={__("State")}
              width={100}
              flexGrow={1}
              cellDataGetter={({ rowData }: { rowData: GatewayShort }) => getGatewayState(rowData.enabled)}
            />
            <Column
              dataKey="healthStatus"
              label={__("Status")}
              width={100}
              flexGrow={1}
              cellDataGetter={({ rowData }: { rowData: GatewayShort }) => healthStatusText[rowData.healthStatus]}
            />
            <Column
              dataKey="avatar"
              label={__("Avatar")}
              width={100}
              flexGrow={1}
              cellDataGetter={({ rowData }: { rowData: GatewayShort }) => rowData.platform?.name ?? ""}
            />
          </Table>
        )}
      </AutoSizer>
    </Segment>
  );
};

function getGatewayState(enabled: boolean): any {
  return enabled ? __("On") : __("Off");
}

export default GatewayTable;
