import React from "react";
import { List } from "semantic-ui-react";
import { ViewManagerResult } from "components/View";
import ViewButton from "components/View/Manager/ViewButton";
import {__} from "@solid/libs/i18n";

import "components/View/Manager/style.css";

type AdminViewListProps = {
  itemId: string;
  vm: ViewManagerResult;
};

const AdminViewList = ({ itemId, vm }: AdminViewListProps) => {
  const { config: { adminViews } } = vm;
  const views = adminViews.find(item => item.id === itemId)?.views;
  return (
    <div className="ViewList">
      <List className="ViewList-ButtonPanel">
        {!!views && views
          .map(view => <ViewButton key={view.id} view={view} vm={vm} editDisabled deleteDisabled shareDisabled viewToWindowDisabled/>)}
      </List>
    </div>
  );
};

export default AdminViewList;
