import React from "react";
import { Icon, SemanticICONS } from "semantic-ui-react";

import { HealthStatus } from "@generated/graphql";
import { __ } from "@solid/libs";

type DevicesInfoProps = {
  total: number,
  countByStatus: Record<HealthStatus, number>,
  icon: SemanticICONS
};

const DeviceInfo = React.memo(({ total, countByStatus, icon }: DevicesInfoProps) => {
  return (
    <span className="AdminLinkList-DeviceInfo">
      <span>{total}&nbsp;<Icon name={icon}/>&nbsp;(</span>
      <span>
        {!!countByStatus[HealthStatus.Normal] &&
        <span className="AdminLinkList-Green AdminLinkList-DeviceCount">{countByStatus[HealthStatus.Normal]}&nbsp;<Icon name={icon}/></span>}
        {!!countByStatus[HealthStatus.Broken] &&
        <span className="AdminLinkList-Red AdminLinkList-DeviceCount">{countByStatus[HealthStatus.Broken]}&nbsp;<Icon name={icon}/></span>}
        {!!(countByStatus[HealthStatus.Degraded] + countByStatus[HealthStatus.Pending]) &&
        <span className="AdminLinkList-Grey AdminLinkList-DeviceCount">{countByStatus[HealthStatus.Degraded] + countByStatus[HealthStatus.Pending]}&nbsp;<Icon name={icon}/></span>}
        {!!countByStatus[HealthStatus.Off] &&
        <span className="AdminLinkList-DeviceCount">{countByStatus[HealthStatus.Off]}&nbsp;<Icon name={icon}/></span>}
      </span>
      <span>)</span>
    </span>
  );
});

export default DeviceInfo;
