import React from "react";

import { HealthStatus } from "@generated/graphql";
import { __ } from "@solid/libs";

type DeviceInfoTextProps = {
  title?: string;
  countByStatus: Record<HealthStatus, number>
};

const DeviceInfoText = React.memo(({ title, countByStatus }: DeviceInfoTextProps) => {
  return (
    <>
      {title && <><br/><span>{title}:</span></>}
      {!!countByStatus[HealthStatus.Normal] &&
        <><br/>{__("Operating")} - {countByStatus[HealthStatus.Normal]}</>}
      {!!countByStatus[HealthStatus.Broken] &&
      <><br/>{__("Broken")} - {countByStatus[HealthStatus.Broken]}</>}
      {!!countByStatus[HealthStatus.Degraded] &&
      <><br/>{__("Degraded")} - {countByStatus[HealthStatus.Degraded]}</>}
      {!!countByStatus[HealthStatus.Pending] &&
      <><br/>{__("Pending")} - {countByStatus[HealthStatus.Pending]}</>}
      {!!countByStatus[HealthStatus.Off] &&
      <><br/>{__("Off")} - {countByStatus[HealthStatus.Off]}</>}
    </>
  );
});

export default DeviceInfoText;
