import React, { useState } from "react";
import { List } from "semantic-ui-react";

import { VaeUpdate } from "@generated/graphql";
import { __ } from "@solid/libs";

import "./style.css";

type VaeUpdatesRowProps = {
  vaeUpdate: VaeUpdate
};

const VaeUpdateLog = ({ vaeUpdate }: VaeUpdatesRowProps) => {
  const [logOpen, setLogOpen] = useState<boolean>(false);

  return (
    <>
      { vaeUpdate.log && vaeUpdate.log.length > 0 &&
      <div className="VaeUpdatesRow-Log">
        { !logOpen ?
          <span className="VaeUpdatesRow-LogText">
            {vaeUpdate.log[0]}
          </span> :
          vaeUpdate.log.map((item, index) =>
            <span className="VaeUpdatesRow-LogText" key={index}>
              {item}
            </span>
          )}
        { vaeUpdate.log.length > 1 &&
          <List.Description
            onClick={(e: React.MouseEvent) => {
              e.preventDefault();
              setLogOpen(!logOpen);
            }} >
            <span className="VaeUpdatesRow-LogLink">
              { logOpen ? __("Hide Log") : __("Show More") }
            </span>
          </List.Description> }
      </div> }
    </>
  );
};

export default VaeUpdateLog;
