import React, { useEffect, useMemo } from "react";
import { Segment } from "semantic-ui-react";
import { AuthType, DeviceBaseConfigType, DeviceProbeInput, useProbeDeviceLazyQuery } from "@generated/graphql";
import Snapshot from "components/Snapshot";

import "./style.css";

type StreamSnapshotProp = {
  deviceId: string;
  url?: string;
  enabled: boolean;
  load: boolean;
  platformId?: string;
};

const StreamSnapshot = ({ url, enabled, deviceId, load, platformId }: StreamSnapshotProp) => {
  const [probeDevice, { data, error, loading }] = useProbeDeviceLazyQuery();
  const snapshot = useMemo(() => data?.probeDevice.snapshots[0], [data]);

  useEffect(() => {
    if (!enabled || !url) {
      return;
    }

    const input: DeviceProbeInput = {
      configType: DeviceBaseConfigType.Url,
      platformId,
      connect: {
        authType: AuthType.NoAuth,
        URL: url
      }
    };

    probeDevice({ variables: {input} });
  }, [enabled, url, platformId]);

  return (
    <Segment className="StreamSnapshot" loading={loading} >
      {(!enabled || !snapshot || !!error) && <Snapshot snapshotId={deviceId} load={load} />}
      {!!snapshot && <img src={`data:image/jpeg;base64, ${snapshot}`} alt="" className="StreamSnapshot-Img"/>}
    </Segment>
  );
};

export default StreamSnapshot;
