import React, { useEffect, useRef } from "react";
import { Card, Icon, Input, Checkbox, Label, Message } from "semantic-ui-react";
import { DiscoveredDevice, DeviceUserInput } from "../CameraDiscovery";
import {__} from "@solid/libs/i18n";

type CameraDemoProps = {
  device: DiscoveredDevice;
  onUserInput: (device: DiscoveredDevice, input: DeviceUserInput) => void;
};

const CameraDemo = ({ device, onUserInput }: CameraDemoProps) => {
  const snapshot = device.snapshots.length > 0 ? device.snapshots[0] : "";
  const snapshotRef = useRef<HTMLImageElement>(null);

  useEffect(() => {
    setTimeout(() => {
      if (snapshotRef.current) {
        snapshotRef.current.src = "";
        snapshotRef.current.src = `data:image/jpeg;base64, ${snapshot}`;
      }
    }, 250);
  }, [snapshot]);

  return (
    <Card className="CameraDiscovery-Camera" color={device.device ? "green" : undefined}>
      <div className="CameraDiscovery-CameraHeader">
        <Checkbox checked={device.userInput.isSelected} onChange={(e, { checked }) => onUserInput(device, { ...device.userInput, isSelected: !!checked })}/>

        {!!device.device &&
        <Label color="blue" content={<>{__("Registered as")}<br/>{`'${device.device.name}'`}</>}/>}
      </div>

      <div className="CameraDiscovery-CameraImage">
        {snapshot ?
          <img ref={snapshotRef} src={`data:image/jpeg;base64, ${snapshot}`} alt=""/> :
          <>
            <Icon name="image outline" size="huge"/>
            <div>{__("Image is not available")}</div>
          </>}
      </div>

      <Card.Content>
        {!!device.userInput.validationError &&
        <Message error content={device.userInput.validationError}/>}

        <div className="CameraDiscovery-CameraFields">
          <div className="CameraDiscovery-CameraFieldLabel">{__("Name")}</div>
          <Input fluid value={device.userInput.name} onChange={e => onUserInput(device, { ...device.userInput, name: e.currentTarget.value })}/>
        </div>
      </Card.Content>
    </Card>
  );
};

export default CameraDemo;
