import React, { useEffect } from "react";
import { Accordion } from "semantic-ui-react";
import { ViewManagerResult } from "components/View";
import { useAccordion, PanelProps } from "components/View/accordion";
import AdminViewList from "components/Admin/AdminViewList";
import {__} from "@solid/libs/i18n";

import "components/View/style.css";

type AdminActivityProps = {
  itemId: string;
  vm: ViewManagerResult;
};

const AdminActivity = ({ itemId, vm }: AdminActivityProps) => {
  const item = vm.config.adminViews.find(item => item.id === itemId);
  const basePanels = getPanels(vm, new Map<string, string>());
  const { panels, activeIndices, filter, onTitleClick, recreatePanels } = useAccordion({
    panels: basePanels,
    activeIndices: new Set<number>(basePanels.map((p, index) => index)),
    recreatePanels: (vm, filter, panels) => getPanels(vm, filter)
  });

  useEffect(() => {
    recreatePanels(vm, filter);
  }, [vm, filter]);

  function getPanels(vm: ViewManagerResult, filter: Map<string, string>): PanelProps[] {
    return item ? [
      { key: item.id, label: item.title, panelContent: <AdminViewList itemId={item.id} vm={vm}/> },
    ] : [];
  }

  return (
    <div className="ViewActivity">
      <Accordion panels={panels} exclusive={false} activeIndex={Array.from(activeIndices.keys())}
        onTitleClick={(e, props) => onTitleClick(e as React.MouseEvent<HTMLDivElement>, props)}
        styled fluid className="ViewActivity-Accordion"/>
    </div>
  );
};

export default AdminActivity;
