import React, {useEffect, useState} from "react";
import {useNavigate} from "react-router-dom";
import { Button, Form, Header, Icon, List, Message, Segment } from "semantic-ui-react";
import classNames from "classnames";
import WithQueryStatus from "components/WithQueryStatus";
import {API} from "@solid/libs/api";
import {Log} from "@solid/libs/log";
import { __ } from "@solid/libs/i18n";

import "./style.css";

const api = new API();

const AccountRecovery = () => {
  const navigate = useNavigate();
  const [email, setEmail] = useState("");
  const [isSendMail, setIsSendMail] = useState(false);
  const [isEmail, setIsEmail] = useState(false);
  const [sending, setSending] = useState(false);

  const sendPassword = async (mail: string) => {
    const userEmail = {"email": mail};
    setSending(true);
    try {
      await api.passwordEmail(userEmail);
      setSending(false);
      setIsSendMail(true);
    } catch (e: any) {
      setIsSendMail(false);
      setSending(false);
      Log.error(e.message);
    }
  };

  const back = () => {
    navigate(-1);
  };

  useEffect(() => {
    if (email.length > 1 && email.includes("@")) {
      setIsEmail(true);
    } else {
      setIsEmail(false);
    }
  }, [email]);

  return (
    <Segment className={classNames("Account-Recovery", {"loading": sending})}>
      <WithQueryStatus loading={sending}>
        <Form onSubmit={(e) => e.preventDefault()}>
          <Form.Field>
            <Header as="h1" className="Account-Recovery-Header">{__("Account Recovery")}</Header>
          </Form.Field>
          {!isSendMail ?
            <>
              <div className="form-text">
                <List>
                  <List.Item>
                    <List.Content>
                      <List.Description>
                        {__("Enter your email address to send a temporary verification link")}
                      </List.Description>
                    </List.Content>
                  </List.Item>
                </List>
              </div>
              <Form.Field>
                <div className="ui left icon input">
                  <input
                    type="email"
                    id="email"
                    tabIndex={1}
                    placeholder={__("Email")}
                    autoFocus
                    onInput={(e) => { setEmail(e.currentTarget.value); }}
                    required
                  />
                  <Icon name="mail" />
                </div>
              </Form.Field>
            </> :
            <Message positive className="Account-Recovery-Message">
              <Message.Header>{__("Success")}</Message.Header>
              <p>
                {__("An email to restore password was successfully sent to ") + email}
              </p>
            </Message>
          }
          <Button
            disabled={!isEmail}
            primary
            fluid
            onClick={() => isSendMail ? back() : sendPassword(email)}
          >
            {isSendMail ? __("Back") : __("Restore Password")}
          </Button>
        </Form>
      </WithQueryStatus>
    </Segment>
  );
};

export default AccountRecovery;
