module.exports = {
    globals: {
        "ts-jest": {
            diagnostics: true,
            tsconfig: "<rootDir>/tsconfig.json",
        },
    },
    transform: {
        "^.+\\.(tsx|ts|js|jsx)?$": "ts-jest",
        "^.+\\.graphql$": "jest-transform-graphql",
        "^.+\\.svg$": "jest-svg-transformer",
        ".*": "babel-jest",
    },
    testRegex: "(/test/.*|(\\.|/)(test|spec))\\.(jsx?|tsx?)$",
    moduleFileExtensions: [
        "ts",
        "tsx",
        "js",
        "jsx",
        "json",
        "node"
    ],
    preset: 'ts-jest',
    testEnvironment: 'jsdom',
    moduleNameMapper: {
        '^@core/(.*)$': '<rootDir>/../client/src/core/$1',
        '^@module/(.*)$': '<rootDir>/../client/src/module/$1',
        '^@generated/(.*)$': '<rootDir>/../client/src/generated/$1',
        '^graphql/(.*)$': '<rootDir>/../client/src/graphql/$1',
        '^components/(.*)$': '<rootDir>/../client/src/components/$1',
        '^electron/(.*)$': '<rootDir>/../client/src/electron/$1',
        '^utils$': '<rootDir>/../client/src/utils',
        "\\.(css|less|scss|sss|styl)$": "<rootDir>../../node_modules/jest-css-modules"
    },
    roots: ['<rootDir>/src/test'],
    // setupFilesAfterEnv: ['<rootDir>/test/setup.js'],
    // snapshotResolver: '<rootDir>/test/snapshotResolver.js',
    // collectCoverage: true,
    collectCoverageFrom: [
        '**/*.ts',
        '!**/node_modules/**',
        '!**/generated/**',
        '!**/graphql/**',
    ],
    // coverageReporters: ['text-summary'], // ['text', text-summary'],
    moduleDirectories: [
        "node_modules",
        "utils",
        __dirname,
    ],
    transformIgnorePatterns: [
        "node_modules/(?!(@libs|vis-timeline|vis-util|vis-data)/)",
    ],
};
