module.exports = {
  root: true,
  "env": {
    "browser": true,
    "node": true
  },
  "globals": {
    "JSX": false,
    "NodeJS": false
  },
  parser: "@typescript-eslint/parser",
  parserOptions: {
    project: "./tsconfig.json",
    ecmaVersion: 2021,
    ecmaFeatures: {
      jsx: true
    }
  },
  plugins: [
    "@typescript-eslint",
    "react",
    "eslint-plugin-react",
    "eslint-plugin-react-hooks",
    "eslint-plugin-import",
    "eslint-plugin-jsx-a11y"
  ],
	settings: {
		react: {
			version: "detect"
		}
	},
	extends: [
    "airbnb-typescript",
    // "plugin:react/recommended"
  ],
  ignorePatterns: [
    "build/*.*",
    "node_modules/*.*",
    "*.js",
    "src/generated/*.*"
  ],
  rules: {
    "@typescript-eslint/quotes": ["warn", "double"],
    "@typescript-eslint/semi": "warn",
    "@typescript-eslint/no-extra-semi": "warn",
    "@typescript-eslint/no-useless-constructor": "warn",
    "@typescript-eslint/comma-dangle": "off",
    "@typescript-eslint/no-shadow": "off",
    "no-trailing-spaces": "warn",
    "eqeqeq": "warn",
    "react/jsx-fragments": "warn",
    "react/no-did-update-set-state": "warn",
    "@typescript-eslint/indent": "warn",
    "react/state-in-constructor": "warn",
    "react/jsx-closing-tag-location": "warn",
    "object-shorthand": "warn",
    "block-spacing": "warn",
    "react/self-closing-comp": "warn",
    "@typescript-eslint/naming-convention": "warn",
    "prefer-arrow-callback": "warn",
    "@typescript-eslint/space-before-function-paren": "warn",
    "import/no-extraneous-dependencies": "warn",
    "array-bracket-spacing": "warn",
    "space-infix-ops": "warn",
    "no-loop-func": "warn",
    "space-unary-ops": "warn",
    "react/jsx-boolean-value": "warn",
    "prefer-const": "warn",
    "no-tabs": "warn",
    "space-in-parens": "warn",
    "no-empty": "warn",
    "no-return-await": "warn",
    "consistent-return": "warn",
    "eol-last": "warn",
    "react/jsx-indent": [1, 2],
    "react/jsx-indent-props": [1, 2],
    "no-useless-computed-key": "warn",
    "react/jsx-curly-brace-presence": "warn",
    "jsx-a11y/alt-text": "warn",
    "no-else-return": "warn",
    "key-spacing": "warn",
    "no-multiple-empty-lines": "warn",
    "import/newline-after-import": "warn",
    "no-lonely-if": "warn",
    "@typescript-eslint/keyword-spacing": "warn",
    "import/no-duplicates": "warn",
    "switch-colon-spacing": "warn",
    "no-extra-boolean-cast": "warn",
    "no-empty-pattern": "warn",
    "react/jsx-curly-spacing": "warn",
    "linebreak-style": "warn",
    "no-mixed-spaces-and-tabs": "warn",
    "quotes": "off",
    "object-curly-newline": "off",
    "operator-linebreak": "off",
    "max-len": "off",
    "@typescript-eslint/no-use-before-define": "off",
    "no-shadow": "off",
    "comma-dangle": "off",
    "no-console": "off",
    "arrow-parens": "off",
    "prefer-template": "off",
    "object-curly-spacing": "off",
    "@typescript-eslint/object-curly-spacing": "off",
    "@typescript-eslint/no-unused-vars": "off",
    "import/order": "off",
    "max-classes-per-file": "off",
    "object-property-newline": "off",
    "@typescript-eslint/dot-notation": "off",
    "no-multi-spaces": "off",
    "no-plusplus": "off",
    "no-restricted-syntax": "off",
    "@typescript-eslint/brace-style": "off",
    "no-restricted-globals": "off",
    "implicit-arrow-linebreak": "off",
    "no-continue": "off",
    "no-param-reassign": "off",
    "@typescript-eslint/no-unused-expressions": "off",
    "radix": "off",
    "react/jsx-first-prop-new-line": "off",
    "react/jsx-max-props-per-line": "off",
    "react/jsx-wrap-multilines": "off",
    "react/jsx-tag-spacing": "off",
    "react/jsx-closing-bracket-location": "off",
    "react/destructuring-assignment": "off",
    "react/jsx-one-expression-per-line": "off",
    "spaced-comment": "off",
    "quote-props": "off",
    "jsx-a11y/click-events-have-key-events": "off",
    "jsx-a11y/no-static-element-interactions": "off",
    "react/button-has-type": "off",
    "no-confusing-arrow": "off",
    "no-nested-ternary": "off",
    "@typescript-eslint/lines-between-class-members": "off",
    "no-mixed-operators": "off",
    "no-await-in-loop": "off",
    "guard-for-in": "off",
    "no-async-promise-executor": "off",
    "class-methods-use-this": "off",
    "import/prefer-default-export": "off",
    "function-paren-newline": "off",
    "import/no-cycle" : "off",
    "no-underscore-dangle": "off",
    "react/jsx-props-no-spreading": "off",
    "jsx-a11y/tabindex-no-positive": "off",
    "jsx-a11y/no-autofocus": "off",
    "no-prototype-builtins": "off",
    "no-restricted-properties": "off",
    "default-case": "off",
    "global-require": "off",
    "no-case-declarations": "off",
    "jsx-a11y/aria-role": "off",
    "jsx-a11y/no-noninteractive-element-interactions": "off",
    "react/no-array-index-key": "off",
    "import/no-dynamic-require": "off",
    "jsx-a11y/anchor-is-valid": "off",
    "jsx-a11y/label-has-associated-control": "off",
    "react/sort-comp": "off",
    "react/jsx-curly-newline": "off",
    "prefer-destructuring": "off",
    "arrow-body-style": "off",
    "react/require-default-props": "off",
    "react/prefer-stateless-function": "off",
    "react/prop-types": "off",
    "react/static-property-placement": "off"
  }
};
