import React, {Component} from 'react';
import {Platform,
        StyleSheet,
        Text,
        View,
        Dimensions,
        TouchableOpacity,
        TouchableHighlight
} from 'react-native';

import VnPlayer from 'react-native-vn-player';

const playerDefaultHeight   = 150;
const playerDefaultWidth    = Dimensions.get('window').width;
//const playerUri = "wss://104-196-71-218.dev2.vsaas.videonext.net:30681/?objid=0f545efe-5924-11e8-94b8-42010a8e0003&streamnum=1";
//const playerUri = "wss://104-196-71-218.dev2.vsaas.videonext.net:30681/?objid=66f3992a-73b6-11e8-acd0-42010a8e0003&streamnum=1";
const playerUri = "wss://35-196-63-249.dev1.vsaas.videonext.net:30681/?objid=933e6a0e-b5ac-11e8-9a9f-42010a8e0005&streamnum=1";
type Props = {};
export default class App extends Component<Props> {

  constructor(props) {
    super(props);
    this.state = {
        progress: 0,
        indeterminate: true,
        paused:false,
        playButtonColor:'rgba(255,255,255,0)',
        loadingColor:'rgba(255,255,255,0)',
        playend:false,
        position:0,
        customStyle:{},
        customButtonStyle:{},
        buttonSize:70,
        progressWidth:playerDefaultWidth
    };
    this.state.customStyle = Object.assign({},this.props.style);

    if(this.state.customStyle.width){
      this.state.progressWidth = this.state.customStyle.width;
      this.state.customButtonStyle.width = this.state.customStyle.width;
    }

    if(this.state.customStyle.height){
      this.state.customButtonStyle.height = this.state.customStyle.height;
      this.state.customButtonStyle.top = - (this.state.customStyle.height);
    }

    if(this.props.buttonSize){
      this.state.buttonSize = this.props.buttonSize;
    }

    this.state.customButtonStyle = Object.assign(this.state.customButtonStyle,this.props.buttonStyle);
  }

    
  render() {
    return (
            <View style={styles.container}>
                 <VnPlayer
                  ref='player'
                  style={[styles.vlcplayer,this.state.customStyle]}
                  play={false}
                  source={{uri:playerUri,width:playerDefaultWidth,height:210}}
                  onStateChanged={this.onStateChanged.bind(this)}
                  onNewStream={this.onNewStream.bind(this)}
                  onNewFrame={this.onNewFrame.bind(this)}
            />

            <TouchableHighlight
               style={styles.button}
              onPress={this.play.bind(this)}>
                <View>
                   <Text style={styles.buttonText}>Play</Text>
                </View>
            </TouchableHighlight>

            <TouchableHighlight
        style={styles.button}
        onPress={this.stop.bind(this)}>
            <View>
            <Text style={styles.buttonText}>Stop</Text>
            </View>
      </TouchableHighlight>   

            <TouchableHighlight
        style={styles.button}
        onPress={this.fullscreen.bind(this)}>
            <View>
            <Text style={styles.buttonText}>Fullscreen</Text>
            </View>
      </TouchableHighlight>   

            
      </View>
    );
  }


    onStateChanged(event)
    {
        console.warn("onStateChanged:" + event);
    }
    
    onNewStream(event)
    {
        console.warn("onNewStream:" + event);
    }
    
    onNewFrame(event)
    {
        console.warn("onNewFrame:" + event);
    }

    play()
    {
        this.refs['player'].play(true);
    }

    stop()
    {
        this.refs['player'].play(false);
    }
    
    fullscreen()
    {
        this.refs['player'].fullscreen(true);
    }
    

}

const styles = StyleSheet.create({
  container: {
    flex: 1,
//    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#F5FCFF',
  },
  welcome: {
    fontSize: 10,
    textAlign: 'center',
    margin: 20,
  },

  //   container: {
  //   flex: 1,

  //   alignItems: 'center',
  //   backgroundColor: '#F5FCFF',
  // },
  vlcplayer:{
    width:playerDefaultWidth,
    height:playerDefaultHeight,
    backgroundColor:'black',
  //  transform:[{rotate:'90deg'}]
  },
  buttonBox:{
    position:'absolute',
    top:-(playerDefaultHeight),
    alignItems: 'center',
    justifyContent: 'center',
    width:playerDefaultWidth,
    height:playerDefaultHeight
  }
});
