#include "vn_asynch_result_internal.h"

///////// VN_Asynch_Result implementation ///////////////
VN_Asynch_Result::VN_Asynch_Result(vn_asynch_result_t *ar)
    : ar_(ar), r_(0)
{        
}

/*virtual*/ VN_Asynch_Result::~VN_Asynch_Result()
{
    if (r_)
        vn_result_destroy(r_);
}

void VN_Asynch_Result::clear()
{
    ar_ = 0;
}

void VN_Asynch_Result::set(vn_result_t *r)
{
    r_ = r;
    
    if (ar_)
    {
        ar_->r = r_;
        ACE_Future<vn_asynch_result_t*>::set(ar_);
    }
}


///////// VN_Asynch_Result_Observer implementation /////////
VN_Asynch_Result_Observer::VN_Asynch_Result_Observer(vn_asynch_result_callback_t callback, void *user_data)
    : callback_(callback), user_data_(user_data)
{
}

/*virtual*/ void VN_Asynch_Result_Observer::update(const ACE_Future<vn_asynch_result_t*> &future)
{
    if (callback_)
    {
        vn_asynch_result_t *ar = 0;
        future.get(ar);
        (*callback_)(ar, user_data_);
    }
}


