/* DO NOT EDIT THIS FILE - it is machine generated */

#ifndef __JMediaPlayer__
#define __JMediaPlayer__

#include <jni.h>
#include <string>
#include <map>
#include <vector>

#include "impl/Mutex.h"

#include "vn_player.h"

using namespace videonext::media;

class JsonObjectsTracker;

class JMediaPlayer
{
public:
    JMediaPlayer(const std::string &url, int streamOverTCP, JNIEnv *jenv, jobject jobj, const std::map<std::string, jmethodID> &jms);
    virtual ~JMediaPlayer();

    void open();
    
    void play();

    void pause();

    void resume(int direction);

    void jump(time_t value);
    
    void setSpeed(float value);

    void setJitterBufferLen(unsigned value);

    void setStepMode(int value);

    void setAnalyticsKeysVisualisation(const std::string &value);

private: // callbacks
    static void new_frame(const vn_player_frame_t*, const vn_player_cache_boundaries_t*, int buf_num, void *client_data);
    
    static void buffer_changed(const vn_player_cache_boundaries_t*, void *client_data);  
	
    static void state_changed(VN_PLAYER_STREAM_STATE, const vn_player_result_status_t*, void *client_data);
	
    static void new_stream(const vn_player_stream_info_t*, void *client_data); 
	
    static void stream_removed(const vn_player_stream_info_t*, void *client_data); 
	
    static void msg_log(const char *msg, void *client_data);

    static void* create_image_buffer(int width, int height, float dar, VN_PLAYER_FRAME_BUFFERS_NUM& buf_num, void *client_data);

    static int  lock_image_buffer(int buf_num, void *client_data);

    static void unlock_image_buffer(int buf_num, void *client_data);

    
private:
    struct vn_player_config_t conf_;	
    struct vn_player_context_t *ctx_;
    jobject jobj_;
    std::map<std::string, jmethodID> jms_;
    std::string url_;

private:
    jbyteArray jRGB24picture_; /*!< array of pixels in Java like color palete (RGB24) */
    jbyte *jRGB24bytes_;        /*!< pointer to j_picture array */

private:
    jbyteArray jPCMframe_;
    jbyte *jPCMbytes_;

private:
    JsonObjectsTracker *jsOT_;

    std::map< std::string, std::vector< std::string > >  analyticsKeysVisualisation_;
    Mutex analyticsKeysVisualisationMutex_;

private:
    float dar; // display aspect ratio

};

#ifdef WIN32
#undef JNICALL
#define JNICALL
#endif

#ifdef __cplusplus
extern "C"
{
#endif

JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_open (JNIEnv *jenv, jobject, jstring/*url*/, jint, jint, jint, jint);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_play (JNIEnv *jenv, jobject, jlong);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_stop (JNIEnv *jenv, jobject, jlong);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_pause (JNIEnv *jenv, jobject, jlong);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_resume (JNIEnv *jenv, jobject, jlong mpID, jint);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_speed (JNIEnv *jenv, jobject, jlong mpID, jfloat);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_stepMode (JNIEnv *jenv, jobject, jlong mpID, jint);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_jumpToTimestamp (JNIEnv *jenv, jobject jobj, jlong mpID, jint value);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_saveCurrentVideoFrame (JNIEnv *jenv, jobject jobj, jstring fileName, jbyteArray byteArray); 
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_setBandwidth (JNIEnv *jenv, jobject jobj, jlong mpID, jint value);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_setAnalyticsKeysVisualisation (JNIEnv *jenv, jobject jobj, jlong mpID, jstring keyList);
JNIEXPORT void JNICALL Java_com_videonext_mplayer_internal_MediaPlayer_setJitterBufferLen (JNIEnv *jenv, jobject, jlong mpID, jint);

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *g_jvm, void *reserved);

#ifdef __cplusplus
}
#endif

#endif /* __JMediaPlayer__ */
