#ifndef _VN_JMEDIACAPTURER_H_
#define _VN_JMEDIACAPTURER_H_

#include <map>
#include <string>

#include <jni.h>

#ifdef WIN32
#undef JNICALL
#define JNICALL
#endif

#ifdef __cplusplus
extern "C"
{
#endif

class JMediaCapturer
{
public:
    JMediaCapturer(const std::map<std::string, jmethodID> &jms, JNIEnv *jenv, jobject jobj);
    virtual ~JMediaCapturer();

    vn_capture_context_t *get_context();

    
private: // callbacks
    static void on_error(int error, const char *error_message, void *client_data);
    
    static void on_audio_stats(short samples[], unsigned samples_count, void *client_data);  

    static void* create_image_preview_buffer(int width, int height, void *client_data);

    static void on_new_preview_image(void *client_data);

private:
    jbyteArray jRGB24picture_; /*!< array of pixels in Java like color palete (RGB24) */
    jbyte *jRGB24bytes_;        /*!< pointer to j_picture array */
    
private:
    vn_capture_context_t *ctx_;
    jobject jobj_;
    std::map<std::string, jmethodID> jms_;

    
};

    
JNIEXPORT jlong JNICALL Java_com_videonext_mplayer_Capturer_nativeInit(JNIEnv *, jobject);

JNIEXPORT jobject JNICALL Java_com_videonext_mplayer_Capturer_nativeGetAudioDevices(JNIEnv *, jobject,
                                                                                    jlong captureId);

JNIEXPORT jobject JNICALL Java_com_videonext_mplayer_Capturer_nativeGetVideoDevices(JNIEnv *, jobject,
                                                                                    jlong captureId);

JNIEXPORT jobject JNICALL Java_com_videonext_mplayer_Capturer_nativeGetVideoParams(JNIEnv *, jobject,
                                                                                   jlong captureId, jstring videoDevice);
    
JNIEXPORT void JNICALL Java_com_videonext_mplayer_Capturer_nativeStartCapture(JNIEnv *, jobject,
                                                                              jlong captureId,
                                                                              jstring audioDevice, jstring videoDevice, jstring videoRes,
                                                                              jstring url, jint bitRate);

JNIEXPORT void JNICALL Java_com_videonext_mplayer_Capturer_nativeStopCapture(JNIEnv *, jobject,
                                                                             jlong captureId);

#ifdef __cplusplus
}
#endif


#endif /* _VN_JMEDIACAPTURER_H_ */
