#ifndef _D3D9_OVERLAY_H_
#define _D3D9_OVERLAY_H_

#ifdef WIN32

#include <string>
#include <vector>
#include <map>

#include "Mutex.h"
#include "D3D9_Common.h"

namespace videonext { namespace media {

class D3D9_Overlay
{
public:
    D3D9_Overlay(IDirect3DDevice9* device, D3DCOLOR color);
    
    virtual ~D3D9_Overlay();
    
    virtual HRESULT draw() = 0;

protected:
    IDirect3DDevice9* device_;
    D3DCOLOR color_;
};

class D3D9_Line_Overlay : public D3D9_Overlay
{
public:
    D3D9_Line_Overlay(IDirect3DDevice9* device, POINT p1, POINT p2, INT width, D3DCOLOR color);

    virtual ~D3D9_Line_Overlay();

    virtual HRESULT draw();

private:
	ID3DXLine *line_;
	D3DXVECTOR2 vectors_[2];
};

class D3D9_Rectangle_Overlay : public D3D9_Overlay
{
public:
    D3D9_Rectangle_Overlay(IDirect3DDevice9* device, RECT rectangle, INT width, D3DCOLOR color);

    virtual ~D3D9_Rectangle_Overlay();

    virtual HRESULT draw();

private:
	ID3DXLine *line_;
	D3DXVECTOR2 vectors_[5];
};

class D3D9_Fill_Rectangle_Overlay : public D3D9_Overlay
{
public:
    D3D9_Fill_Rectangle_Overlay(IDirect3DDevice9* device, RECT rectangle, D3DCOLOR color);

    virtual ~D3D9_Fill_Rectangle_Overlay();

    virtual HRESULT draw();

private:
    IDirect3DVertexBuffer9 *vertex_buffer_;
    RECT rect_;
};


class D3D9_Polygon_Overlay : public D3D9_Overlay
{
public:
    D3D9_Polygon_Overlay(IDirect3DDevice9* device, POINT* points, INT pointsLen, INT width, D3DCOLOR color);
    
    virtual ~D3D9_Polygon_Overlay();

    virtual HRESULT draw();

private:
	ID3DXLine *line_;
	D3DXVECTOR2* vectors_;
	INT numOfVectors_;
};

class D3D9_Fill_Polygon_Overlay : public D3D9_Overlay
{
public:
    D3D9_Fill_Polygon_Overlay(IDirect3DDevice9* device, POINT* points, INT pointsLen, D3DCOLOR color);
    
    virtual ~D3D9_Fill_Polygon_Overlay();

    virtual HRESULT draw();

private:
    IDirect3DVertexBuffer9 *vertex_buffer_;
    std::vector<POINT> points_;
};


class D3D9_Ellipse_Overlay : public D3D9_Overlay
{
public:
    D3D9_Ellipse_Overlay(IDirect3DDevice9* device, INT center_x, INT center_y, INT width, INT height, INT line_width, D3DCOLOR color);
    
    virtual ~D3D9_Ellipse_Overlay();

    virtual HRESULT draw();

private:
    int center_x_;
    int center_y_;
    int width_;
    int height_;
    ID3DXLine *line_;
    std::vector<D3DXVECTOR2> vectors_;
};

class D3D9_Fill_Ellipse_Overlay : public D3D9_Overlay
{
public:
    D3D9_Fill_Ellipse_Overlay(IDirect3DDevice9* device, INT center_x, INT center_y, INT width, INT height, D3DCOLOR color);
    
    virtual ~D3D9_Fill_Ellipse_Overlay();

    virtual HRESULT draw();

private:
    int center_x_;
    int center_y_;
    int width_;
    int height_;
    std::vector<POINT> points_;
    IDirect3DVertexBuffer9 *vertex_buffer_;
};


class D3D9_Font
{
public:
    D3D9_Font(IDirect3DDevice9* device, LPCSTR fontName, INT fontSize, UINT weight);

    virtual ~D3D9_Font();

    HRESULT prepare_text(char *text);

    HRESULT draw_text(char *text, LPRECT rect, D3DCOLOR color);

private:
    ID3DXFont *font_;
};

class D3D9_Font_Factory
{
private:
    D3D9_Font_Factory();
	
    typedef std::map<std::string, D3D9_Font*> Factory_Map;
    Factory_Map factory_map_;
public:
    ~D3D9_Font_Factory();

    static D3D9_Font_Factory *instance();

    void clear();

    D3D9_Font* get_font(IDirect3DDevice9* device, LPCSTR fontName, INT fontSize, UINT weight);
};

class D3D9_Text_Overlay : public D3D9_Overlay
{
public:
    D3D9_Text_Overlay(IDirect3DDevice9* device, LPCSTR text, RECT pos, INT size, D3DCOLOR color, LPCSTR font);

    virtual ~D3D9_Text_Overlay();

    virtual HRESULT draw();

private:
    std::string text_;
    RECT pos_;
    D3D9_Font* font_;
};


class D3D9_Overlay_Store
{
    typedef std::map<uint64_t, D3D9_Overlay*> Overlay_Map;

public:
    D3D9_Overlay_Store();

    virtual ~D3D9_Overlay_Store();

    void add_overlay(D3D9_Overlay* overlay, uint64_t id);

    void remove_overlay(uint64_t id);

    void draw();

    bool is_empty();

    void clear();

private:
	Overlay_Map overlays_;
	Mutex lock_; 
};

}}

#endif //WIN32

#endif /* _D3D9_OVERLAY_H_ */
