#ifndef _SDL2_RENDERER_IMPL_H_
#define _SDL2_RENDERER_IMPL_H_

#include "SDL2/SDL.h"
#include "Renderer_Impl.h"

extern "C" {
#include "libavutil/log.h"
}

namespace videonext { namespace media {

#define _V(x, e, t, ret)                                 \
do {                                                     \
    if(x e) {                                            \
        av_log(NULL, AV_LOG_ERROR,                       \
               "%s:%d %s failed with error: %s\n",       \
               __FILE__, __LINE__, strlen(#t) ? #t : #x, \
               SDL_GetError());                          \
        ret                                              \
    }                                                    \
} while(0);

#define V_R(x, e, t) _V(x, e, t, return -1;)

class SDL2_Renderer_Impl : public Renderer_Impl
{
public:
    SDL2_Renderer_Impl();
    virtual ~SDL2_Renderer_Impl();

    // make uploading texture in the main video thread without extra copying the frame
    int upload_texture();

    // redefined virtual functions from Renderer_Impl
    virtual int init(void* window_handle);
    virtual VN_PLAYER_PIXEL_FORMAT get_preferred_pixel_format() const;
    virtual int process(const vn_player_frame_t *frame);
    virtual int draw(Image_Fill_Mode mode, Image_Calibration *ic, Image_Pan_Zoom *pz);

private:
    SDL_Window*   sdl_window_;
    SDL_Renderer* renderer_;
    SDL_Texture*  texture_;
    unsigned texture_width_;
    unsigned texture_height_;
    int sdl_texture_fmt_;

    SDL_bool   texture_uploaded_;
    SDL_mutex* lock_;
    SDL_cond*  cond_;
    const vn_player_frame_t *frame_;
};

}}

#endif // _SDL2_RENDERER_IMPL_H_
