#ifndef _RENDERER_IMPL_H_

#define _RENDERER_IMPL_H_

#include <math.h>
#include "vn_player.h"
#include "vn_renderer.h"

namespace videonext { namespace media {

struct Image_Calibration : public vn_image_calibration_t
{
    Image_Calibration();

    Image_Calibration(const vn_image_calibration_t &o);

    friend bool operator== (const Image_Calibration &ic1, const Image_Calibration &ic2);
    friend bool operator!= (const Image_Calibration &ic1, const Image_Calibration &ic2);
};

struct Image_Pan_Zoom : public vn_image_pan_zoom_t
{
    Image_Pan_Zoom();

    Image_Pan_Zoom(const vn_image_pan_zoom_t &o);

    friend bool operator== (const Image_Pan_Zoom &ic1, const Image_Pan_Zoom &ic2);
    friend bool operator!= (const Image_Pan_Zoom &ic1, const Image_Pan_Zoom &ic2);
};

enum Image_Fill_Mode
{
    Keep_Aspect_Ratio = 0,
    Stretch           = 1
};
        
class Renderer_Impl
{
public:

    Renderer_Impl();
    
    virtual ~Renderer_Impl();
    
    virtual int init(void* window_handle) = 0;

    virtual int process(const vn_player_frame_t *f) = 0;
    
    virtual int draw(Image_Fill_Mode mode, Image_Calibration *ic, Image_Pan_Zoom *pz) = 0;
    
    virtual VN_PLAYER_PIXEL_FORMAT get_preferred_pixel_format() const = 0;

    void show_metadata(bool value) { show_metadata_ = value; }

    bool show_metadata() const { return show_metadata_; }
    
protected:
    bool show_metadata_;
};
        
}}

#endif /* _RENDERER_IMPL_H_ */
