/**
 * @version $Id: Point.h 23056 2011-07-15 11:54:28Z nkrachkovsky $
 * ------------------------------------------------------------------------------
 * Point
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2010
 * ------------------------------------------------------------------------------
 */

#pragma once
#ifndef H_Point
#define H_Point

class Point2 {
public:
    Point2(void) {}
    Point2(int x, int y)
    {
        this->x = x;
        this->y = y;
    }
    //~Point2(void) {}
    void setLocation(int x, int y)
    {
        this->x = x;
        this->y = y;
    }
    void setLocation(const Point2& pt)
    {
        this->x = pt.x;
        this->y = pt.y;
    }

    Point2& operator += ( const Point2& pt )
    {
        x += pt.x;
        y += pt.y;
        return *this;
    }

    bool operator == ( const Point2& pt ) const
    {
        return x == pt.x && y == pt.y;
    }

    bool operator != ( const Point2& pt ) const
    {
        return x != pt.x || y != pt.y;
    }

public:
    int x;
    int y;
};

#endif
