/**
 * @version $Id: AbstractObjectsTracker.h 23039 2011-07-04 07:47:47Z nkrachkovsky $
 * ------------------------------------------------------------------------------
 * This class represents AbstractObjectsTracker abstract class for rendering
 * analytics and metadata
 * ------------------------------------------------------------------------------
 * @author Nickolay Krachkovsky
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2010
 * ------------------------------------------------------------------------------
 */

#ifndef ABSTRACTOBJECTSTRACKER_H
#define ABSTRACTOBJECTSTRACKER_H

#include <vector>
#include <string>
#include <map>
#include <list>

#ifdef WIN32
#include <winsock2.h>
#endif

#include "Graphics.h"

#define MILLION 1000000

class AbstractObjectsTracker
{
public:
    struct LinkEntry {
        std::string text;
        Rectangle2 rect;

        LinkEntry(const std::string& linkText = "", const Rectangle2& boundRect = Rectangle2())
            : text(linkText), rect(boundRect)
        { }
    };

public:
    AbstractObjectsTracker()
        : frame_time( 0 )
    { }

    virtual ~AbstractObjectsTracker() {}

    virtual void setObjectsData(const std::string& Bitstream) = 0;

    virtual void setMetadataInfo(const std::map< std::string, std::vector< std::string > >& VisibleMetadata) = 0;

    /**
     * Draw analytics objects over some part of zoomed im image at any place of the destination screenRect
     */
    virtual void parseAndDraw(Graphics* g2, const Rectangle2& dstRect, const Rectangle2& srcRect, float zoomFactor) = 0;

    virtual std::list<LinkEntry> linksList() { return std::list<LinkEntry>(); }
public:
    void setFrameTime( struct timeval* tv ) { frame_time = tv->tv_sec * (long long) MILLION + tv->tv_usec; }
    long long frameTime() { return frame_time; }
private:
    long long frame_time;
};

#endif // ABSTRACTOBJECTSTRACKER_H
