/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#include "FileMediaStreamProducerImpl.h"
#include "MediaStreamProducer.h"
#include "RTSPMediaStreamProducerImpl.h"
#ifndef WIN32
#include "HTTPMediaStreamProducerImpl.h"
#endif
#include "WebSocketMediaStreamProducerImpl.h"

namespace videonext { namespace media {

MediaStreamProducer::MediaStreamProducer(MediaStreamHandler *mediaStreamHandler, const std::string &url, unsigned cacheSize, 
                                         unsigned streamId, bool streamOverTCP, unsigned bufferLen, float speed)
{
   if (url.find("http://") != std::string::npos)
   {
#ifndef WIN32
      pimpl_ = new HTTPMediaStreamProducerImpl(mediaStreamHandler, url, cacheSize, streamId);
#endif
   }
   else if (url.find("rtsp://")  != std::string::npos)
   {
      pimpl_ = new RTSPMediaStreamProducerImpl(mediaStreamHandler, url, cacheSize, streamId, streamOverTCP, bufferLen, 1.f);
   }
   else if (url.find("file://")  != std::string::npos)
   {
       pimpl_ = new FileMediaStreamProducerImpl(mediaStreamHandler, url, cacheSize, streamId, speed);
   }
   else if (url.find("ws://") != std::string::npos || url.find("wss://") != std::string::npos)
   {
       pimpl_ = new WebSocketMediaStreamProducerImpl(mediaStreamHandler, url, cacheSize, streamId, bufferLen, speed);
   }
}

/*virtual*/ MediaStreamProducer::~MediaStreamProducer()
{ 
   delete pimpl_;
}

void MediaStreamProducer::open()
{
   pimpl_->open();
}

void MediaStreamProducer::play()
{
   pimpl_->play();
}

void MediaStreamProducer::pause()
{
   pimpl_->pause();   
}

void MediaStreamProducer::teardown()
{
   pimpl_->teardown();   
}

void MediaStreamProducer::setPlayDirection(int direction)
{
   pimpl_->setPlayDirection(direction);
}

void MediaStreamProducer::setStepMode(bool stepMode)
{
   pimpl_->setStepMode(stepMode);
}

void MediaStreamProducer::setSpeed(float speed)
{
   pimpl_->setSpeed(speed);
}
        
void MediaStreamProducer::setJitterBufferLen(unsigned value)
{
    pimpl_->setJitterBufferLen(value);
}

        
void MediaStreamProducer::enableDecoding(unsigned type, PIXEL_FORMAT preferedPixelFormat)
{
   pimpl_->enableDecoding(type, preferedPixelFormat);
}

void MediaStreamProducer::moveToTimestamp(time_t time)
{
   pimpl_->moveToTimestamp(time);

}

bool MediaStreamProducer::startRecording(const char* file_name, const std::map<std::string, std::string>& metadata)
{
	return pimpl_->startRecording(file_name, metadata);
}

bool MediaStreamProducer::endRecording(bool stop)
{
	return pimpl_->endRecording(stop);
}

void MediaStreamProducer::muteAudio(bool mute)
{
    pimpl_->muteAudio(mute);
}

}}
