#include "MediaObjects.h"
#include "vn_result.h"

#ifndef SKM_MEDIA_CLIENT_H                                                                                            
#define SKM_MEDIA_CLIENT_H

namespace videonext { namespace media {

struct MediaClientImpl;
struct ResultStatus;

class MediaClient
{
public:
   static MediaClient* instance();

   MediaClient();
    
   ~MediaClient();
    
   void login(ResultStatus *result,
              const std::string &host,
              unsigned port,
              const std::string &username, 
              const std::string &password,
              bool ssl, unsigned timeout);

   void setAuth(const std::string& php_sess_id, const std::string& csrf_token);

   void getUserRoles(ResultStatus *result, 
                     std::map<std::string/*role id*/, Role> *roles);
	                
   void getMediaObjectSets(ResultStatus *result, std::map<std::string, MediaObjectsSet> *sets);

    
   void getMediaObjects(ResultStatus *result,
                        std::map<std::string/*role id*/, Role> *roles,
                        std::map<std::string, MediaObjectsSet> *sets,
                        std::map<std::string/*object id*/, MediaObject> *mediaObjects);

   /** 
    * Get media URL 
    *  
    * @param objectId
    * @param isLocal return url for local streaming if true
    * @param startTime Archive start time (UTC timestamp)
    * @param endTime Archive end time (UTC timestamp)
    * @param transcode Transcode to different media format. Only "h264" currently supported  
    * @param dimensions If transcoding enabled set frame dimensions in form "WxH", ex: "320x240"
    * @param url [out]
    */
   void getMediaURL(ResultStatus *result,
                    std::string  *url,
                    const std::string& objectId,
                    bool isLocal = false,
                    const std::string& audioObjectId = "",
                    time_t startTime = 0,
                    time_t endTime = 0,
                    const std::string &transcode = std::string(),
                    const std::string &dimensions = std::string());
    

   /** 
    * Get events from eventlog
    * 
    * @param result 
    * @param events [out] result events map
    * @param role_id [in] rile ID
    * @param filter [in]  complex event filter
    */
   void getEvents(ResultStatus *result,
                  std::map<unsigned, Event> *events,
                  std::string& role_id,
                  std::string& filter);

   /*
    * param startTime by default start of current day
    * param endTime  by default now
    * param maxcount

                  time_t startTime = 0,
                  time_t endTime = 0,
                  unsigned maxcount = 20);*/

   /**
    * Performs ptz command
    *
    * @param result
    * @param objectId
    * @param mode PTZ mode
    * @param cmd command in verbal form "left|right|up|down|downleft|upright|downright|upleft|in|out"
    */
   void performPTZCommand(ResultStatus *result,
                          const std::string& objectId,
                          const std::string& mode,
                          const std::string& cmd);

   void getServerInfo(ResultStatus *result, DynaParams *info);

   void getSnapshot(ResultStatus *result, const std::string& obj_id, time_t ts,
                    unsigned stream_num, int metadata, std::string* img);

   void setUserRole(ResultStatus *result, const std::string& roleID);
   std::string getUserRole();

   MediaClientImpl* impl() { return pimpl_; }

private:
    MediaClientImpl *pimpl_;
};

}}

#endif
