/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 03/04/2009
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdarg.h>
#include "AdaptiveUsageEnvironment.h"

namespace videonext { namespace media {

AdaptiveUsageEnvironment::AdaptiveUsageEnvironment(TaskScheduler& taskScheduler, MediaStreamHandler *mediaStreamHandler)
   : BasicUsageEnvironment0(taskScheduler), mediaStreamHandler_(mediaStreamHandler) {   
}

AdaptiveUsageEnvironment::~AdaptiveUsageEnvironment() {
}

AdaptiveUsageEnvironment*
AdaptiveUsageEnvironment::createNew(TaskScheduler& taskScheduler, MediaStreamHandler *mediaStreamHandler) {
    return new AdaptiveUsageEnvironment(taskScheduler, mediaStreamHandler);
}

int AdaptiveUsageEnvironment::getErrno() const {

#if defined(__WIN32__) || defined(_WIN32)
#ifndef _WIN32_WCE
  
  //if (errno == 0) {
      //errno = WSAGetLastError();
    //  errno = GetLastError();   
      return GetLastError();
      //  return WSAGetLastError();
  //}
   //*((AdaptiveEnvironment*)this) << "errno: " << errno << "\n";
#endif
#endif
#if defined(_WIN32_WCE)
    //return WSAGetLastError();
    return GetLastError();
#else
  return errno;
#endif
}

void AdaptiveUsageEnvironment::setResultErrMsg(MsgString msg) {
#if defined(__WIN32__) || defined(_WIN32)
    char* errmsg;
    if (FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ALLOCATE_BUFFER,
                  NULL, 
                  getErrno(), 
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                  (char*)&errmsg, 
                  0, 
                  NULL))
    {
        setResultMsg(msg);
        appendToResultMsg((const char*)errmsg);
        LocalFree(errmsg);
    }
#else
    setResultMsg(msg);
    appendToResultMsg(strerror(getErrno()));
#endif 
}


void AdaptiveUsageEnvironment::reportBackgroundError() {
   log_i(getResultMsg());
}


UsageEnvironment& AdaptiveUsageEnvironment::operator<<(char const* str) {
    log_i(str);
    return *this;
}

UsageEnvironment& AdaptiveUsageEnvironment::operator<<(int i) {
    char str[256];
    snprintf(str, sizeof(str), "%d", i);
    
    log_i(str);
    
    return *this;
}

UsageEnvironment& AdaptiveUsageEnvironment::operator<<(unsigned u) {
    char str[256];
    snprintf(str, sizeof(str), "%u", u);
    
    log_i(str);
    
    return *this;
}

UsageEnvironment& AdaptiveUsageEnvironment::operator<<(double d) {
    char str[256];
    snprintf(str, sizeof(str), "%f", d);
    
    log_i(str);
    
    return *this;
}

UsageEnvironment& AdaptiveUsageEnvironment::operator<<(void* p) {
    char str[256];
    snprintf(str, sizeof(str), "%p", p);
    
    log_i(str);
    
    return *this;
}

void AdaptiveUsageEnvironment::log(const char *format, ...)
{    
    va_list args;
    va_start(args, format);

    char msg[1024];
    vsnprintf(msg, sizeof(msg)-1, format, args);    

    va_end(args);

    log_i(msg);
}

void AdaptiveUsageEnvironment::log_i(MsgString msg) {
    mediaStreamHandler_->log(msg);
}

}}
