# Native vn-player

Build of this native module should be made inside of the `client-sdk` for all supported platforms except *win32*.
For *win32* we can just copy this `vn-player` folder to some Windows box and build it there. In such a case all needed
precompiled binaries will be downloaded automatically.

The result of the build are native modules for both node and electron,
which must be packetized and placed on the public available HTTPS-capable host.

All stages will be considered in detail below.

**IMPORTANT!!! `VNPlayer.ts` is an important part of the implementation on a par with the native C++ part.
It was planned by design that it should be extended and reused in all projects that depends on `vn-player` native addon including `ds-electron` and `Solid`.
`client-sdk` SHOULD remain the ONLY place for farther native player improvements. So do NOT copy/paste any part of native addon into your project directly to avoid any inconsistencies at some point.**


## BUILD
General requirements:
- prebuilt `client-sdk` and *3rdparty* libraries for the desired platform and architecture
- NodeJS installed
- configured build environment

Build phase depends on a target platform.

### *nix-like including *MacOS* and *Linux*

```
cd client-sdk/src/nodejs/vn-player
yarn run init    # initial preparation to build from source
```

1. Build for node:
`yarn run build-node`

2. Build for electron:
`yarn run build-electron`

### *Windows*

1. First of all let's prepare build environment.
Simply open Powershell or Git Bash with administrator privileges and execute (it is assumed that the NodeJS is already installed):

    `yarn global add windows-build-tools`

2. Once installed you still need to set PYTHON environment variable. Validate that Python is indeed found in the correct folder:

   `"%USERPROFILE%\.windows-build-tools\python27\python.exe"`

3. Create your (user) environment variable:

   `setx PYTHON "%USERPROFILE%\.windows-build-tools\python27\python.exe"`

4. Restart cmd, and verify that variable exists via `set PYTHON` which should return the variable.

After such preparations, the rest steps are the same as for *nix-like platforms. 'yarm run init` step includes downloading prebuilt client-sdk.


## PACKAGE
```
yarn pack
yarn run pack-node
yarn run pack-electron
```


## DEPLOY
As a result of BUILD and PACKAGE steps we have one tarball in `./` and two in `build/stage`.
We need to copy them manually to the public available HTTPS-capable host.
I chose our ftp for this purpose: `ftp.videonext.net`.

For example for x86_64-darwin:
```
scp vn-player-2.0.0.tgz <user>@ftp.videonext.net:/ftp/data/private/native-addons/
scp build/stage/node-darwin-x64.tar.gz <user>@ftp.videonext.net:/ftp/data/private/native-addons/vn_player/v2.0.0/
scp build/stage/electron-darwin-x64.tar.gz <user>@ftp.videonext.net:/ftp/data/private/native-addons/vn_player/v2.0.0/
```


## USAGE
Now we can use our native module in some project by adding it via url into `package.json`:
```
"dependencies": {
    "vn-player": "https://ftp.videonext.net/private/native-addons/vn-player-2.0.0.tgz",
```

## TEST
You can run the test script using any of the following commands:

```
yarn test
```


## PREPARE SDK PREBUILT
This step relates more for win32 platform.

1. Build the sdk briefly like this (build environment must be configured, including installed mingw32 compiler, cmake, etc...):
    ```
    cd client-sdk/3rdparty/src/
    ./build.sh x86_64-mingw32
    cd ../../build
    make -f x86_64-mingw32.mak
    ```
2. Let's pack our prebuilt package:
    ```
    cd ../src/nodejs/vn-player/sdk
    BUILD_TARGET=x86_64-mingw32 yarn pack
    ```
3. Now we need to put our prebuilt package to FTP or AWS S3.
If storing into FTP:
    `scp vn-sdk-prebuilt-x86_64-mingw32-<12 SYMBOLS FROM LAST GIT COMMIT>-<VERSION>.tgz <user>@ftp.videonext.net:/ftp/data/private/native-addons/`
If storing into AWS S3:
    `aws-2.7 s3 cp vn-sdk-prebuilt-x86_64-mingw32-<12 SYMBOLS FROM LAST GIT COMMIT>-<VERSION>.tgz s3://files.titansys.com/private/native-addons/`
4. Add to or update vn-player `package.json` optional dev dependencies like this:
    ```
    "optionalDevDependencies": {
        "vn-sdk-prebuilt": "https://ftp.videonext.net/private/native-addons/vn-sdk-prebuilt-x86_64-mingw32-1db9df11b63a-1.0.0.tgz"
    }
    ```

Good luck!;)
