export class PlayerStatistics {
	constructor() {
		this.statistics = {
			videoStartTime: 0,
			videoPictureCounter: 0,
			windowStartTime: 0,
			windowPictureCounter: 0,
			fps: 0,
			fpsMin: 1000,
			fpsMax: -1000,
			webGLTextureUploadTime: 0
		};

		this.onStatisticsUpdated = function () {};
	}

	updateStatistics() {
		const s = this.statistics;
		s.videoPictureCounter += 1;
		s.windowPictureCounter += 1;
		const now = Date.now();
		if (!s.videoStartTime) {
			s.videoStartTime = now;
		}
		const videoElapsedTime = now - s.videoStartTime;
		s.elapsed = videoElapsedTime / 1000;
		if (videoElapsedTime < 1000) {
			return;
		}

		if (!s.windowStartTime) {
			s.windowStartTime = now;
			return;
		} else if ((now - s.windowStartTime) > 1000) {
			const windowElapsedTime = now - s.windowStartTime;
			const fps = (s.windowPictureCounter / windowElapsedTime) * 1000;
			s.windowStartTime = now;
			s.windowPictureCounter = 0;

			if (fps < s.fpsMin) s.fpsMin = fps;
			if (fps > s.fpsMax) s.fpsMax = fps;
			s.fps = fps;
		}

		const fps = (s.videoPictureCounter / videoElapsedTime) * 1000;
		s.fpsSinceStart = fps;
		this.onStatisticsUpdated(this.statistics);
	}
}
