import * as path from "path";
import * as fs from "fs";
import * as logger from "./logger";

// export const isPackage = !require("electron-is-dev");

export function getPackageResourcesPath(): string {
  return path.join(__dirname, "../");
}

export function loadPackageEnvironment(): void {
  /*
  if (!isPackage) {
    return;
  }
  /*
  const envFile = path.join(getPackageResourcesPath(), "main", ".env");

  loadDefaultEnv();
  load(envFile);
  */
}

export function getPackageVersion(): string {
  let packageJson: Record<string, string> | undefined;
  const packageFile = path.join(getPackageResourcesPath(), "package.json");
  if (fs.existsSync(packageFile)) {
    try {
      packageJson = JSON.parse(fs.readFileSync(packageFile, "utf8"));
    }
    catch (e) {
      logger.error("Could not read package.json:", e);
    }
  }
  return packageJson?.version ?? "";
}

export function isFirstRun(): boolean {
  return process.argv.length > 1 ? process.argv[1] === "--squirrel-firstrun" : false;
}
