import electron, {BrowserWindow, crashReporter} from "electron"; // Module to control application life.
import {loadPackageEnvironment} from "./packageUtils";
import Window, { WindowId } from "./Window";
import * as logger from "./logger";
// import * as autoUpdate from "./autoUpdate";
// import * as viewWindow from "./ViewWindow";
import * as screen from "./screen";
import * as store from "./store";
// import * as linkProvision from "./linkProvision";

loadPackageEnvironment();

const API_MINIDUMP = process.env.API_MINIDUMP;
crashReporter.start({
  companyName: "titan-systems",
  productName: "solid",
  ignoreSystemCrashHandler: true,
  uploadToServer: !!API_MINIDUMP,
  submitURL: API_MINIDUMP,
  globalExtra: {
    cluster: process.env.API_BACKEND ?? ""
  }
});

const app = electron.app; // Module to create native browser window.

// increase number of contexts for creating more native players
app.commandLine.appendSwitch("max-active-webgl-contexts", "64");

// app.commandLine.appendSwitch("enable-webgl-draft-extensions");
// app.commandLine.appendSwitch("ignore-gpu-blocklist");

// Let's select which implementation of GL the GPU process should use.
// Options are:
// desktop: whatever desktop OpenGL the user has installed (Linux and Mac default).
// egl:     whatever EGL / GLES2 the user has installed (Windows default - actually ANGLE).
// swiftshader: The SwiftShader software renderer (on some Macs choosed by default and give crappy picture in our case).
if (process.platform === "darwin") {
  app.commandLine.appendSwitch("use-gl", "egl");
}

// Renderer Node fs API stops working on page reload
// https://github.com/electron/electron/issues/22119
// app.allowRendererProcessReuse = false;

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow: BrowserWindow | null = null;

const env = process.env.NODE_ENV || "development";
const isDev = env !== "production";

function createWindow() {
  const window = new Window(WindowId.Main);
  // Create the browser window.
  mainWindow = window.createMain();

  logger.init(mainWindow);

  loadPackageEnvironment();
//  autoUpdate.init(mainWindow);

  screen.init(mainWindow);
  // viewWindow.init(mainWindow);
  store.init();
  // linkProvision.init(mainWindow);

  window.loadURL();

  if (isDev) {
    mainWindow.webContents.openDevTools();
  }

  // Emitted when the window is closed.
  mainWindow.on("closed", () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null;
  });
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on("ready", createWindow);

// Quit when all windows are closed.
app.on("window-all-closed", () => {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== "darwin") {
    app.quit();
  }
});

app.on("activate", () => {
  // On OS X it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow();
  }
});
