import React, {useEffect, useRef} from "react";
import {CameraCellParameters, PlayerCell} from "@solid/player-cell";
import {UUID} from "@solid/types";
// import {MSEMediaPlayerMetadataType} from "@solid/player";

import "vis-timeline/styles/vis-timeline-graph2d.css";
import "@solid/timeline/vistimeline.css";
import "@solid/player/mediaplayer.css";
import "@solid/player/mediaplayercontrols.css";
import "@solid/joystick/ptz.css";
import "@solid/player-cell/digitalzoom.css";
import "@bevacqua/rome/dist/rome.css";
import "@solid/player-cell/cell.css";
import "./PlayerCellLegacy.css";

type PlayerCellProps = {
  obj: UUID,
  time: Date,
  header: string
};

const PlayerCellLegacy = (props: PlayerCellProps, ref: React.Ref<HTMLDivElement>) => {
  const playerCellNodeRef = !ref || typeof ref === "function" ? useRef<HTMLDivElement>(null) : ref;
  const cameraCellRef = useRef<PlayerCell | null>(null);

  const initCell = () => {
    if (typeof ref === "function") {
      ref(playerCellNodeRef.current);
    }

    if (!playerCellNodeRef.current || !props.obj) {
      return;
    }

    cameraCellRef.current = new PlayerCell();

    const parameters: CameraCellParameters = {
      isShowHeader: true,
      isTimeLineVisible: true,
      // isControlsHoverable: !props.isArchive,
      isPlayOnStart: false,
      isPTZVisible: true,
      isDigitalZoomVisible: true,
      isFullScreenControlVisible: true,
      // metadataType: MSEMediaPlayerMetadataType.TRIGGERED,
      // isShowPauseButton: props.showPauseButton,
      // disableLocalTransport: true
    };

    cameraCellRef.current.init(
      playerCellNodeRef.current,
      props.obj,
      props.header,
      props.time?.getTime(),
      parameters,
      {}
    );
  };

  const destroyCell = () => {
    if (!cameraCellRef.current) {
      return;
    }

    cameraCellRef.current && cameraCellRef.current.destroy();
    cameraCellRef.current = null;
  };

  useEffect(() => {
    if (!playerCellNodeRef.current) {
      return;
    }

    initCell();

    return () => {
      destroyCell();
    };
  }, [props.obj, props.time]);

  return (
    <div ref={playerCellNodeRef} className="cell_wrapper"/>
  );
};

export default PlayerCellLegacy;
