## Prerequisites
- node >= 16.10
- yarn package manager, no need to install, just it through Corepack.
Corepack is included by default with all Node.js installs, but is currently opt-in. To enable it, run the following command:
```shell
corepack enable
```

## Init
```shell
yarn install
```

## Release workflow
1. check for changed files and select release strategy for each of them (patch, minor, major, ...).
Run from current, ./nodejs dir
```shell
yarn version check --interactive
```
2. apply selected changes
```shell
yarn version apply --all
```

## Version
Go to necessary package dir

Run command for version increase (patch, minor, major)
```shell
yarn version patch
```
This command will increase version of current package and updates dependencies of dependent packages

## Publish
Go to necessary package dir

Login, if you are not logged before
```shell
yarn npm login --publish
```
and publish to registry
```shell
yarn npm publish
```
If you receive error like
```text
➤ YN0035: Repository does not allow updating assets: npm-hosted
➤ YN0035:   Response Code: 400 (Bad Request)
➤ YN0035:   Request Method: PUT
➤ YN0035:   Request URL: http://nexus.dev.videonext.net:8081/repository/npm-hosted/@libs%2fplayer-native
```
Then you should increase current package version

## Error reporting

For centralized error reporting we use sentry.io

You should specify sentry auth token in ~/.sentryclirc

For auto create this file, run
```shell
yarn sentry-cli login
```
and follow the instructions.

Then publish package:
- build
- debug info sent to sentry.io (uploads you can check in https://sentry.io/settings/titan-systems/projects/solid/debug-symbols/)
- publish to npm registry
