package com.videonext.mplayer.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwingMediaPlayer extends JPanel {

	private static final long serialVersionUID = -659563983522171343L;
	MediaPlayer mediaPlayer;
	MediaPlayerListener playerListener;
	JPanel panel;
	JButton btnPlay, btnStop, btnPause;
	JFrame parent;
	String url;
	
	// fullscreen support
	JFrame fullscreenFrame; 
	Rectangle restoredBounds;
	
	static GraphicsDevice device = GraphicsEnvironment
	        .getLocalGraphicsEnvironment().getScreenDevices()[0];

	/**
	 * Create the application.
	 * @throws Exception 
	 */
	public SwingMediaPlayer(String url, MediaPlayerListener playerListener) throws Exception {
		this.url = url;
		mediaPlayer = new MediaPlayer("");
		
		initialize();

	
		mediaPlayer.setMediaPlayerListener(playerListener);
		mediaPlayer.setCacheSize(10000000); // 10 MB
		mediaPlayer.setBackground(Color.BLACK);
		mediaPlayer.setParameter("videoURL", url);
		mediaPlayer.sendCommand("play");
		
	}

	public MediaPlayer getMediaPlayer()
	{
		return mediaPlayer;
	}
		
	/**
	 * Initialize the contents of the frame.
	 * @throws Exception 
	 */
	private void initialize() throws Exception {
		this.setBounds(100, 100, 694, 437);
		
		this.setLayout(new BorderLayout());
		this.add(mediaPlayer, BorderLayout.CENTER);
	
		panel = new JPanel();
		FlowLayout flowLayout = (FlowLayout) panel.getLayout();
		flowLayout.setAlignment(FlowLayout.LEFT);
		this.add(panel, BorderLayout.SOUTH);
		
		btnPlay = new JButton("Play");
		btnPlay.setEnabled(false);
		btnPlay.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				if (!btnStop.isEnabled())
					mediaPlayer.setParameter("videoURL", url);
				
				mediaPlayer.sendCommand("play");
				
				btnPlay.setEnabled(false);
				btnPause.setEnabled(true);
				btnStop.setEnabled(true);
			}
		});
		panel.add(btnPlay);
		
		btnStop = new JButton("Stop");
		btnStop.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				mediaPlayer.sendCommand("stop");
				btnPlay.setEnabled(true);
				btnPause.setEnabled(false);
				btnStop.setEnabled(false);
			}
		});
		
		btnPause = new JButton("Pause");
		btnPause.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				mediaPlayer.sendCommand("pause");
				btnPlay.setEnabled(true);
				btnPause.setEnabled(false);
			}
		});
		
		panel.add(btnPause);
		panel.add(btnStop);
		
		JButton fullscreenButton = new JButton("FullScr");
		fullscreenButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			
				if (fullscreenFrame == null) // entering full screen
				{				
					fullscreenFrame = new JFrame();
					parent = (JFrame) SwingUtilities.getWindowAncestor(SwingMediaPlayer.this);
					
					restoredBounds = parent.getBounds();
					restoredBounds.height--;
					parent.setBounds(restoredBounds);
					
					
					fullscreenFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					fullscreenFrame.setExtendedState(JFrame.MAXIMIZED_BOTH);
					fullscreenFrame.setUndecorated(true);
					fullscreenFrame.getContentPane().add(SwingMediaPlayer.this, BorderLayout.CENTER);
					fullscreenFrame.setResizable(false);
					fullscreenFrame.setAlwaysOnTop(false);
	                
					device.setFullScreenWindow(fullscreenFrame);
					
					
					Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
					fullscreenFrame.setBounds(0,0,screenSize.width, screenSize.height);
					fullscreenFrame.pack();
					fullscreenFrame.repaint();
					
					//panel.setBackground(new Color(0,0,0,125));
					
				}
				else
				{
					parent.getContentPane().add(SwingMediaPlayer.this, BorderLayout.CENTER);
					parent.setBounds(restoredBounds);
					//SwingMediaPlayer.this.setBounds(restoredBounds);
					parent.pack();
					parent.repaint();
					
					fullscreenFrame.setVisible(false);
					fullscreenFrame.dispose();
					device.setFullScreenWindow(null);
					fullscreenFrame = null;
					
					restoredBounds.height++;
					parent.setBounds(restoredBounds);
					parent.repaint();
				}
							
			}
		});
		panel.add(fullscreenButton);
	
	}
}
