package com.videonext.mplayer.internal;

import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Date;

public interface MediaPlayerListener {
    // invoked when player changes its status
    public void statusChanged(int status, int resultCode, String resultMessage);

    // invoked when player receives new video frame or audio data
    // img is only valid during call this method
    public void newFrame(long frameTimestamp, long bufStartTimestamp, long bufEndTimestamp, BufferedImage img);

    // invoked when player is in pause state, but internal
    // buffer keeps pumping frames from server
    public void bufferChanged(long startTimestamp, long endTimestamp);

    // invoked when player receive mouse click event
    public void mouseClicked(MouseEvent e, boolean isPlayerActive);
    
    // invoked when player receive mouse move event
    public void mouseMoved(MouseEvent e, boolean isPlayerActive);
    
    // invoked when player receive mouse exit event
    public void mouseExit(MouseEvent e, boolean isPlayerActive);
    
    
    // invoked when snapshot saved or cancelled 
    public void snapshotFinished();
     
    public boolean canDisplayFrame(Date date);
}
