package com.videonext.mplayer.api.events;

import com.videonext.mplayer.api.ControllerEvent;

public class NewFrameEvent extends ControllerEvent {

	private static final long serialVersionUID = 1L;

	private long framePTSMillis; /// frame presentation time UTC
	private long bufStartMillis; /// buffer start time
	private long bufEndMillis;   /// buffer end time
	
	public NewFrameEvent(Object source, long framePTSMillis, long bufStartMillis, long bufEndMillis) {
		super(source);
		
		this.framePTSMillis = framePTSMillis;
		this.bufStartMillis = bufStartMillis;
		this.bufEndMillis   = bufEndMillis;
	}

	public long getFramePTSMillis() {
		return framePTSMillis;
	}

	public void setFramePTSMillis(long framePTSMillis) {
		this.framePTSMillis = framePTSMillis;
	}

	public long getBufStartMillis() {
		return bufStartMillis;
	}

	public void setBufStartMillis(long bufStartMillis) {
		this.bufStartMillis = bufStartMillis;
	}

	public long getBufEndMillis() {
		return bufEndMillis;
	}

	public void setBufEndMillis(long bufEndMillis) {
		this.bufEndMillis = bufEndMillis;
	}
}
