package com.videonext.mplayer.api;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;

import com.videonext.mplayer.SinglePlayerSyncronizer;
import com.videonext.mplayer.PlayerGroup.Metronome;

public interface IPlayerGroup extends IPlayerController {
    
	public void setPlayerURLProvider(IPlayerURLProvider provider);

	/**
     * Switch group to play live video
     *
     */
	public void switchToLive();
	
	/**
     * Switch group to play archived video
     *
     */
	public void switchToArchive(Date startTime, Date endTime); 
	
	/**
     * Tells the <CODE>IPlayerGroup</CODE> to assume control of another <code>IPlayer</code>.
     *
     * @param newController The <code>IPLayer</code> to be managed.
     *
     */
    public void addPlayer(IPlayer newPlayer);

    /**
     * Tells the <CODE>IPlayerGroup</CODE> to stop controlling a <code>IPlayer</code>.
     *
     * @param oldController The <code>IPlayer</code> to stop managing.
     */
    public void removePlayer(IPlayer oldPlayer);
    
    public abstract ArrayList<SinglePlayerSyncronizer> getSynchronizers();

	public abstract Metronome getMetronome();

	public abstract long getPlayingTime();

	public abstract void play(int direction);

	public abstract void pause();

	public abstract void close();

	public abstract int getState();

	public abstract void addControllerListener(IControllerListener listener);

	public abstract void removeControllerListener(IControllerListener listener);

	public abstract void setAspectRation(int value);

	public abstract void changeSpeed(float value);

	public abstract void jumpTo(Date date);

	public abstract void setStepMode(boolean flag);

	public abstract void nextStep(int direction);

	public abstract void setBrightness(float value);

	public abstract String getLog();

	public abstract boolean canDisplayFrame(Date date);

	public abstract void addPropertyChangeListener(
			PropertyChangeListener listener);

	public abstract void removePropertyChangeListener(
			PropertyChangeListener listener);

	public abstract void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener);

	public abstract void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener);
  
}
