package com.videonext.mplayer.api;

public interface IPlayerController extends IAudioController, IAspectRatioController, IFramerateController, 
										   IPlaybackController, IStepModeController, IVisualEnchancementController, IZoomController 
{

	public final static int Forward_Direction = 1;
	public final static int Backward_Direction = -1;

	/**
	 * Start playing stream
	 * @param direction
	 */
	void play(int direction);
	
	/**
	 * Stop playing stream
	 * @param direction
	 */
	void stop();
	
	/**
	 * Pause stream
	 */
	void pause();
	
	/**
	 * Stop playing stream(s) immediately. 
	 * Free all allocated resources
	 * 
	 * After invoking this method <code>IPlayer</code> is ready to open new <code>URL</code> again 
	 */
	void close();

	 /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Idle = 0;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Playing_Server = 1;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Playing_Buffer = 2;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Stopped = 3;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Opening = 4;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Buffering = 5;
    /**
     * Returned by <CODE>getState</CODE>.
     */
    public final static int Opened = 6;
  
    /**
     * Gets the current state of this <code>IController</code>.
     * The state is an integer constant as defined above.
     * <p>
     * <B>Note:</B>
     * A race condition can occur between
     * the return of this method and the execution of
     * a state changing method.
     * 
     * @return The <code>IController's</code> current state.
     */
    public int getState();
	
}
