package com.videonext.mplayer.api;

import java.util.Date;

public interface IControllerListener {
	
	/**
     * This method is called when an event is generated by a 
     * <code>IController</code> that this listener is registered with.
     *
     * @param event The event generated.
     */
	public void controllerUpdate(ControllerEvent event);
    
	/**
     * This method is called when controller wants to display next video frame 
     *
     * @param date The date of current frame.
     */    
    public boolean canDisplayFrame(Date date);
}
