package com.videonext.mplayer.api;

public interface IController {
	/**
     * Specifies a <code>IControllerListener</code> to which
     * this <code>IController</code>  will send events.
     * A <code>IController</code> can have multiple
     * <code>IControllerListeners</code>.
     *
     * @param listener The listener to which the <CODE>IController</CODE>
     * will post events.
     */
    public void addControllerListener(IControllerListener listener);

    /**
     * Removes the specified listener from this <code>IController's</code>
     * listener list.
     *
     * @param listener The listener that has been receiving events from this
     * <code>IController</code>.
     */
    public void removeControllerListener(IControllerListener listener);   
}
