package com.videonext.mplayer.api;

import java.util.List;

public interface ICapturer extends IController {

	void init() throws Exception;
	
	List<String> getVideoDevices() throws Exception;
	
	List<String> getAudioDevices() throws Exception;
	
	List<String> getVideoParams(String videoDevice) throws Exception;
	
	void start(String audioDEvice, String videoDevice, String videoParams, int bitRate) throws Exception;
	
	void stop() throws Exception;
	
	void setURLProvider(ICapturerURLProvider provider);
	
	byte[] getPreviewBuffer();
	
    int getPreviewWidth();
	
	int getPreviewHeight();
	
}
