/*******************************************************************************
 * Copyright (c) 2010 - 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Lars Vogel <lars.Vogel@gmail.com> - Bug 419770
 *******************************************************************************/
package com.videonext.mplayer.test.parts;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Label;

import java.awt.Frame;

import org.eclipse.swt.awt.SWT_AWT;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Panel;
import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

import com.videonext.mplayer.Player;
import com.videonext.mplayer.PlayerGroup;
import com.videonext.mplayer.api.ControllerEvent;
import com.videonext.mplayer.api.IControllerListener;
import com.videonext.mplayer.api.IPlayer;
import com.videonext.mplayer.api.IPlayerURLProvider;

import org.eclipse.swt.widgets.ProgressBar;

public class Matrix {

	private PlayerGroup playerGroup = new PlayerGroup();
	private PlayerGroupListener playerGroupListener = new PlayerGroupListener();
	
	
	@PostConstruct
	public void createComposite(Composite parent) {
	
		playerGroup.addControllerListener(playerGroupListener);
		playerGroup.setPlayerURLProvider(new PlayerGroupURLProvider());
		
		parent.setLayout(null);
		
		Map<String, Object> playerConfig = new HashMap<String, Object>();
		playerConfig.put(IPlayer.PROPERTY_STREAM_OVER_TCP, Boolean.TRUE);
		
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setBounds(0, 0, 835, 601);
		
		////////////////////////////////////////////////////////////////
		Composite composite_1 = new Composite(composite, SWT.EMBEDDED);
		composite_1.setBounds(0, 0, 417, 300);
				
		
		JLayeredPane lpane = new JLayeredPane();
		Frame frame_1 = SWT_AWT.new_Frame(composite_1);
		frame_1.setLayout(new BorderLayout());
		frame_1.add(lpane, BorderLayout.CENTER);
		lpane.setBounds(0, 0, 417, 300);
		
	
		Player player_1 = new Player("101", playerConfig);
		player_1.setBounds(0, 0, 417, 300);
		
		lpane.add(player_1, new Integer(0), 0);
      
				
				
		Canvas canvas = new Canvas();
		//canvas.setBackground(new Color(1f,0f,0f,1.0f ));
		lpane.add(canvas,  new Integer(1), 0);
		canvas.setBounds(0, 0, 417, 300);
		
		
		Display display = composite.getDisplay();
		Shell shell = SWT_AWT.new_Shell(display, canvas);
		Button btn = new Button(shell, SWT.NONE);
		btn.setBounds(25, 30, 70, 24);
		btn.setText("Test");
		
		
		playerGroup.addPlayer(player_1);
		

		
		
		
		
		//		
//		frame_1.setComponentZOrder(panel_1, 0);
//		frame_1.setComponentZOrder(canvas, 1);
//		
		 //frame_1.pack();
	     //frame_1.setVisible(true);
		
		
		
		
		
		
//		Display display = composite.getDisplay();
//		Shell shell = SWT_AWT.new_Shell(composite.getDisplay(), (Canvas)panel_1.getVisualComponent());
//		
//		
//		
//		shell.setBackground(display.getSystemColor(SWT.COLOR_RED));
//		//define a region 
//		Region region = new Region();
//		Rectangle pixel = new Rectangle(0, 0, 1, 1);
//		for (int y = 0; y < 200; y+=2) {
//				for (int x = 0; x < 200; x+=2) {
//					pixel.x = x;
//					pixel.y = y;
//					region.add(pixel);
//				}
//			}
//		//define the shape of the shell using setRegion
//		shell.setRegion(region);
//	
//		
		
		
		
		
		//org.eclipse.swt.widgets.Canvas canvas = new org.eclipse.swt.widgets.Canvas(shell, SWT.NO_BACKGROUND);
		//shell.setBackgroundMode(SWT.INHERIT_FORCE);
		//canvas.setForeground(composite.getDisplay().getSystemColor(SWT.COLOR_WHITE));
		//shell.setAlpha(255);
		
		//Button btn = new Button(shell, SWT.NONE);
		//btn.setBounds(25, 30, 70, 24);
		//btn.setText("Test");
		//btn.moveAbove(composite_1);
		
	
		//////////////////////////////////////////////////////////////
		
		//////////////////////////////////////////////////////////////
		Composite composite_2 = new Composite(composite, SWT.EMBEDDED);
		composite_2.setBounds(0, 301, 417, 300);
		
		Frame frame_2 = SWT_AWT.new_Frame(composite_2);
		Panel panel_2 = new Panel();
		frame_2.add(panel_2);
		panel_2.setLayout(new BorderLayout(0, 0));
		
		JRootPane rootPane_2 = new JRootPane();
		panel_2.add(rootPane_2);			
		///////////////////////////////////////////////////////////////////
		
		//////////////////////////////////////////////////////////////////
		Composite composite_3 = new Composite(composite, SWT.EMBEDDED);
		composite_3.setBounds(418, 0, 417, 300);
		
		Frame frame_3 = SWT_AWT.new_Frame(composite_3);
		Panel panel_3 = new Panel();
		frame_3.add(panel_3);
		panel_3.setLayout(new BorderLayout(0, 0));
		
		JRootPane rootPane_3 = new JRootPane();
		panel_3.add(rootPane_3);
		/////////////////////////////////////////////////////////////////
		
		/////////////////////////////////////////////////////////////////
		Composite composite_4 = new Composite(composite, SWT.EMBEDDED);
		composite_4.setBounds(418, 301, 417, 300);

		Frame frame_4 = SWT_AWT.new_Frame(composite_4);
		Panel panel_4 = new Panel();
		frame_4.add(panel_4);
		panel_4.setLayout(new BorderLayout(0, 0));
		
		JRootPane rootPane_4 = new JRootPane();
		panel_4.add(rootPane_4);
		
		/////////////////////////////////////////////////////////////////
		
		Button btnPlay = new Button(parent, SWT.NONE);
		btnPlay.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				playerGroup.switchToLive();
			}
		});
		btnPlay.setBounds(25, 630, 70, 24);
		btnPlay.setText(">");
		
		Button btnPause = new Button(parent, SWT.NONE);
		btnPause.setText("||");
		btnPause.setBounds(90, 630, 70, 24);
		
		Button btnStop = new Button(parent, SWT.NONE);
		btnStop.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				playerGroup.close();
			}
		});
		btnStop.setText("[]");
		btnStop.setBounds(159, 630, 70, 24);
	}

	@Focus
	public void setFocus() {
		
	}

	class PlayerGroupListener implements IControllerListener {

		@Override
		public void controllerUpdate(ControllerEvent event) {
			System.out.println("controllerUpdate: " + event.getClass().getName() + " " + event);
		}
	}
	
	class PlayerGroupURLProvider implements IPlayerURLProvider {

		@Override
		public String[] getLiveURL(IPlayer[] players) {
			String urls[] = new String[players.length];
			for (int i = 0; i < players.length; i++) {
				urls[i] = new String("rtsp://192.168.0.91:8554/xmedia?dev=" + players[i].getId() + "&authorizationid=0");
			}
			return urls;
		}

		@Override
		public String[] getArchiveURL(IPlayer[] players, Date startTime,
				Date endTime) {
			// TODO Auto-generated method stub
			return null;
		}
		
	}
}