/*
#  $Id$
# -----------------------------------------------------------------------------
#  The part of 'VideoNEXT MediaClient SDK'
# -----------------------------------------------------------------------------
#  Author: Petrov Maxim, 08/20/2010
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
*/

#ifndef _VN_PLAYER_INTERNAL_H_
#define _VN_PLAYER_INTERNAL_H_

#include <stdint.h>
#include "vn_player.h"
#include "MediaStreamProducer.h"
#include "impl/Mutex.h"

class VN_Media_Stream_Handler; //forward

struct vn_player_context_t
{
    virtual ~vn_player_context_t()
    {
        magic = 0;
    }

   typedef videonext::media::Mutex Mutex;
   typedef videonext::media::Cond Cond;
   vn_player_config_t config;
   vn_player_callbacks_t callbacks;
   videonext::media::MediaStreamProducer *producer;
   VN_Media_Stream_Handler *handler;
   bool audio_muted;
   bool delete_after_play;
   Cond player_mutex;
   int buffer_len;
   Mutex callback_mutex;
   volatile bool did_resume;
   volatile bool is_running;
   bool need_finalize;
   uint32_t magic;
};



#endif /* _VN_PLAYER_IMPL_H_ */
