#include <stdlib.h>
#include "vn_malloc.h"

struct vn_alloc_t
{
    vn_custom_free_callback_t free_cb;
};

void *vn_malloc(size_t size, vn_custom_free_callback_t free_cb)
{
    void *p = calloc(1, size + sizeof(struct vn_alloc_t));

    if (free_cb)
    {
        vn_alloc_t *vn_alloc = (vn_alloc_t *)p;
        vn_alloc->free_cb = free_cb;
    }


    return (char*)p + sizeof(struct vn_alloc_t);
}

void vn_free(void *p)
{
    p = (char*)p - sizeof(struct vn_alloc_t);

    vn_alloc_t *vn_alloc = (vn_alloc_t *)p;

    vn_custom_free_callback_t free_cb = vn_alloc->free_cb;

    if (free_cb)
    {
        vn_alloc->free_cb = 0;
        free_cb((char*)p + sizeof(struct vn_alloc_t));
    }
    else
    {
        free(p);
    }
}
