#include "vn_kv_list.h"
#include "vn_malloc.h"

static void vn_kv_list_destroy_internal(vn_kv_t **kv)
{
    for (vn_kv_t **p = kv; *p != 0; p++)
    {
        if ((*p)->key)
            vn_free((*p)->key);
        
        if ((*p)->value)
            vn_free((*p)->value);
        
        vn_free(*p);
    }

    vn_free(kv);
}
 
vn_kv_t **vn_kv_list_create(unsigned size)
{
    vn_kv_t **kv = (vn_kv_t **)vn_malloc((size + 1) * sizeof(vn_kv_t *), (vn_custom_free_callback_t)vn_kv_list_destroy_internal);
    
    for (unsigned i = 0; i < size; i++)
    {
        kv[i] = (vn_kv_t *)vn_malloc(sizeof(vn_kv_t), 0);
    }
    
    return kv;
}

void vn_kv_list_destroy(vn_kv_t **kv)
{
    vn_free(kv);
}

