struct VS_INPUT
{
    float4 Position   : POSITION;
    float2 Texture    : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float2 Texture    : TEXCOORD0;
};

float Magnification;

sampler2D  Texture1Sampler;

float4x4 WorldViewProj;
float4x4 RotationZMatrix;

bool FlipHorizontally;
bool FlipVertically;

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;                                   

    Out.Position = mul(In.Position, mul(WorldViewProj, RotationZMatrix));  
	Out.Texture  = In.Texture;   

	if(FlipHorizontally)
	{
		Out.Texture  = float2(Out.Texture.x, 1 - Out.Texture.y);                       
	}

	if(FlipVertically)
	{
		Out.Texture  = float2(1 - Out.Texture.x, Out.Texture.y);   
	}

    return Out;                                      
}

float4 ps_main( in VS_OUTPUT In ) : COLOR0
{
	float2 center = float2(0.5, 0.5);	
	float2 centerToPixel = In.Texture.xy - center;
	float2 samplePoint = center + centerToPixel / Magnification;
	
	return tex2D(Texture1Sampler, samplePoint);
}
