#ifndef _D3D9_COMMON_H_
#define _D3D9_COMMON_H_

#include <windows.h>
#include <d3d9.h>
#include <d3dx9shader.h>
#include <d3dx9math.h>
#include <dxerr9.h>

extern "C" {
#include "libavcodec/avcodec.h"
#include "libavformat/avformat.h"
#include "libswscale/swscale.h"
#include "libavutil/pixfmt.h"
}

namespace videonext { namespace media {

//#define VN_RENDERER_DEBUG

#ifdef VN_RENDERER_DEBUG
#define VN_D3DDEVTYPE D3DDEVTYPE_REF
#else
#define VN_D3DDEVTYPE D3DDEVTYPE_HAL
#endif

struct VERTEX
{
    D3DXVECTOR3 pos;        // vertex untransformed position
    D3DCOLOR    color;      // diffuse color
    D3DXVECTOR2 texPos;     // texture relative coordinates
};

#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1)

#define D3DFMT_YV12 (D3DFORMAT)MAKEFOURCC('Y', 'V', '1', '2')
#define D3DFMT_NV12 (D3DFORMAT)MAKEFOURCC('N', 'V', '1', '2')
#define D3DPRESENTFLAG_OVERLAY_YCbCr_BT709 0x00000100

#define IDirect3D9_SafeRelease(p)               \
    do { if (p) {                               \
           IDirect3D9_Release(p);               \
           p = 0;                               \
          }                                     \
    } while (0)


#define HR(x)                                           \
do {                                                    \
    if (FAILED(x))                                      \
    {                                                   \
        av_log(NULL, AV_LOG_ERROR, "%s:%d " #x " failed: %s\n", __FILE__, __LINE__, DXGetErrorString9(x)); \
        return x;                                       \
    }                                                   \
} while (0)




}}


#endif /* _D3D9_COMMON_H_ */
